/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.ArrayUtil;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SelectedTemplateComposite;
import com.aptana.ui.widgets.StepIndicatorComposite;
import com.aptana.ui.wizards.WizardNewProjectCreationPage;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CommonWizardNewProjectCreationPage
extends WizardNewProjectCreationPage
implements IWizardProjectCreationPage,
IStepIndicatorWizardPage {
    private Label warningLabel;
    private IProjectTemplate projectTemplate = null;
    protected StepIndicatorComposite stepIndicatorComposite;
    protected String[] stepNames;

    public CommonWizardNewProjectCreationPage(String pageName, IProjectTemplate projectTemplate) {
        super(pageName);
        this.projectTemplate = projectTemplate;
    }

    public boolean isCloneFromGit() {
        return false;
    }

    public String getCloneURI() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageLayout = GridLayoutFactory.fillDefaults().spacing(0, 5).create();
        pageComposite.setLayout((Layout)pageLayout);
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.stepIndicatorComposite = new StepIndicatorComposite(pageComposite, this.stepNames);
        this.stepIndicatorComposite.setSelection(this.getStepName());
        this.createTopArea(pageComposite);
        super.createControl(pageComposite);
        ((Composite)this.getControl()).setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        ((Composite)this.getControl()).setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1).create());
        this.setControl((Control)pageComposite);
        this.createProjectTemplateSection(pageComposite);
        this.createWarningArea();
    }

    protected void createTopArea(Composite parent) {
    }

    private void createWarningArea() {
        Composite control = (Composite)this.getControl();
        final Font font = new Font((Device)control.getDisplay(), SWTUtils.italicizedFont((Font)this.getFont()));
        this.warningLabel = new Label(control, 64);
        this.warningLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 1).grab(true, false).create());
        this.warningLabel.setFont(font);
        this.warningLabel.setForeground(UIUtils.getDisplay().getSystemColor(3));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
    }

    protected void createProjectTemplateSection(Composite parent) {
        if (this.projectTemplate != null) {
            new SelectedTemplateComposite(parent, this.projectTemplate);
        }
    }

    protected boolean validatePage() {
        boolean isValid = super.validatePage();
        if (this.warningLabel != null) {
            this.warningLabel.setText("");
        }
        if (isValid) {
            Object[] files;
            File locationFile = this.getLocationPath().toFile();
            boolean existing = false;
            if (this.useDefaults()) {
                Object[] files2;
                String defaultLocation = TextProcessor.process((String)Platform.getLocation().append(this.getProjectName()).toOSString());
                File dir = new File(defaultLocation);
                if (dir.exists() && !ArrayUtil.isEmpty((Object[])(files2 = dir.list()))) {
                    existing = true;
                }
            } else if (locationFile.exists() && !ArrayUtil.isEmpty((Object[])(files = locationFile.list()))) {
                existing = true;
            }
            if (existing) {
                this.warningLabel.setText(Messages.CommonWizardNewProjectCreationPage_location_has_existing_content_warning);
                this.warningLabel.getParent().layout(true);
            }
        }
        return isValid;
    }

    public String getStepName() {
        return Messages.NewProjectWizard_Step_Lbl;
    }

    public void initStepIndicator(String[] stepNames) {
        this.stepNames = stepNames;
    }
}

